# KeenIcons Reference Guide

This document contains all available KeenIcons organized by category. All icons are available in multiple styles: `duotone`, `filled`, `outline`, and `solid`.

## Usage

Use icons in your templates with:
```html
{{ theme.getKeenIcon('icon-name') }}
```

## Abstract Icons
- `abstract`
- `abstract-1` through `abstract-49`

## Action & File Management Icons
- `add-files`
- `add-folder`
- `add-notepad`
- `additem`
- `delete-files`
- `delete-folder`
- `update-file`
- `update-folder`

## Arrow & Navigation Icons
- `arrow-circle-left`
- `arrow-circle-right`
- `arrow-down`
- `arrow-down-left`
- `arrow-down-refraction`
- `arrow-down-right`
- `arrow-left`
- `arrow-right`
- `arrow-right-left`
- `arrow-up`
- `arrow-up-down`
- `arrow-up-left`
- `arrow-up-refraction`
- `arrow-up-right`
- `arrow-mix`
- `arrow-two-diagonals`
- `arrow-zigzag`
- `arrows-circle`
- `arrows-loop`
- `double-down`
- `double-left`
- `double-left-arrow`
- `double-right`
- `double-right-arrow`
- `double-up`
- `to-left`
- `to-right`
- `up-diagonal`
- `up-down`

## Business & Commerce Icons
- `address-book`
- `award`
- `badge`
- `bank`
- `bill`
- `briefcase`
- `brifecase-cros`
- `brifecase-tick`
- `brifecase-timer`
- `basket`
- `basket-ok`
- `credit-cart`
- `two-credit-cart`
- `cheque`
- `dollar`
- `euro`
- `percentage`
- `price-tag`
- `purchase`
- `receipt-square`
- `wallet`

## Chart & Data Visualization Icons
- `chart`
- `chart-line`
- `chart-line-down`
- `chart-line-down-2`
- `chart-line-star`
- `chart-line-up`
- `chart-line-up-2`
- `chart-pie-3`
- `chart-pie-4`
- `chart-pie-simple`
- `chart-pie-too`
- `chart-simple`
- `chart-simple-2`
- `chart-simple-3`
- `bar-chart`
- `graph`
- `graph-2`
- `graph-3`
- `graph-4`
- `graph-up`

## Communication & Messaging Icons
- `message-add`
- `message-edit`
- `message-minus`
- `message-notify`
- `message-programming`
- `message-question`
- `message-text`
- `message-text-2`
- `messages`
- `sms`
- `notification`
- `notification-1`
- `notification-bing`
- `notification-circle`
- `notification-favorite`
- `notification-on`
- `notification-status`

## Device & Hardware Icons
- `android`
- `apple`
- `bluetooth`
- `cd`
- `desktop-mobile`
- `devices`
- `devices-2`
- `laptop`
- `mouse`
- `mouse-circle`
- `mouse-square`
- `pad`
- `screen`
- `tablet`
- `tablet-delete`
- `tablet-down`
- `tablet-ok`
- `tablet-text-down`
- `tablet-text-up`
- `tablet-up`
- `keyboard`
- `simcard`
- `simcard-2`

## File & Document Icons
- `file-added`
- `file-deleted`
- `file-down`
- `file-left`
- `file-right`
- `file-sheet`
- `file-up`
- `files`
- `some-files`
- `folder`
- `folder-added`
- `folder-down`
- `folder-up`
- `document`
- `notepad`
- `notepad-bookmark`
- `notepad-edit`
- `note`
- `note-2`
- `clipboard`
- `copy`
- `copy-success`

## Interface & UI Icons
- `menu`
- `burger-menu`
- `burger-menu-1`
- `burger-menu-2`
- `burger-menu-3`
- `burger-menu-4`
- `burger-menu-5`
- `burger-menu-6`
- `setting`
- `setting-2`
- `setting-3`
- `setting-4`
- `check`
- `check-circle`
- `check-squared`
- `double-check`
- `double-check-circle`
- `cross`
- `cross-circle`
- `cross-square`
- `plus`
- `plus-circle`
- `plus-squared`
- `minus`
- `minus-circle`
- `minus-folder`
- `minus-squared`
- `dots-circle`
- `dots-circle-vertical`
- `dots-horizontal`
- `dots-square`
- `dots-square-vertical`
- `dots-vertical`
- `toggle-off`
- `toggle-off-circle`
- `toggle-on`
- `toggle-on-circle`
- `switch`
- `slider`
- `slider-horizontal`
- `slider-horizontal-2`
- `slider-vertica`
- `slider-vertical`

## Location & Navigation Icons
- `geolocation`
- `geolocation-home`
- `map`
- `pin`
- `entrance-left`
- `entrance-right`
- `exit-down`
- `exit-left`
- `exit-right`
- `exit-right-corner`
- `exit-up`
- `compass`
- `magnifier`
- `search-list`

## Media & Social Icons
- `picture`
- `speaker`
- `spotify`
- `youtube`
- `instagram`
- `facebook`
- `twitter`
- `snapchat`
- `tiktok`
- `twitch`
- `behance`
- `dribbble`
- `figma`
- `github`
- `google`
- `google-play`
- `microsoft`
- `dropbox`
- `slack`
- `trello`
- `whatsapp`
- `paypal`
- `nexo`

## Security & Authentication Icons
- `shield`
- `shield-cross`
- `shield-search`
- `shield-slash`
- `shield-tick`
- `lock`
- `lock-2`
- `lock-3`
- `key`
- `key-square`
- `face-id`
- `fingerprint-scanning`
- `security-user`

## Social & User Icons
- `user`
- `user-edit`
- `user-square`
- `user-tick`
- `users`
- `people`
- `teacher`
- `classmates`
- `profile-circle`

## Technology & Development Icons
- `code`
- `html`
- `css`
- `js`
- `js-2`
- `ts`
- `react`
- `vue`
- `vuesax`
- `angular`
- `bootstrap`
- `laravel`
- `python`
- `yii`
- `technology-1`
- `technology-2`
- `technology-3`
- `technology-4`
- `artificial-intelligence`
- `square-brackets`

## Transportation & Travel Icons
- `airplane`
- `airplane-square`
- `bus`
- `car`
- `ship`
- `rocket`
- `route`
- `router`

## Utility & Tools Icons
- `calculator`
- `calculatoror`
- `clock`
- `electronic-clock`
- `time`
- `timer`
- `trash`
- `trash-square`
- `wifi`
- `wifi-home`
- `wifi-square`
- `wlan`
- `wrench`
- `syringe`
- `thermometer`
- `pencil`
- `eraser`
- `brush`
- `paintbucket`
- `color-swatch`
- `colors-square`
- `size`
- `maximize`
- `focus`
- `loading`
- `status`
- `verify`

## Weather & Nature Icons
- `sun`
- `moon`
- `night-day`
- `ocean`
- `drop`
- `tree`
- `virus`
- `thermometer`
- `celsius-cel`

## Miscellaneous Icons
- `abstract` (various numbered versions)
- `bandage`
- `book`
- `book-open`
- `book-square`
- `bookmark`
- `bookmark-2`
- `bucket`
- `bucket-square`
- `crown`
- `crown-2`
- `cup`
- `cursor`
- `data`
- `diamonds`
- `disk`
- `dislike`
- `dj`
- `external-drive`
- `eye`
- `eye-slash`
- `feather`
- `flag`
- `flash-circle`
- `flask`
- `frame`
- `gift`
- `glass`
- `handcart`
- `heart`
- `heart-circle`
- `home`
- `home-1`
- `home-2`
- `home-3`
- `icon`
- `illustrator`
- `information`
- `information-1`
- `information-2`
- `information-3`
- `information-4`
- `joystick`
- `kanban`
- `like`
- `like-2`
- `like-folder`
- `like-shapes`
- `like-tag`
- `lots-shopping`
- `lovely`
- `mask`
- `medal-star`
- `milk`
- `more-2`
- `office-bag`
- `package`
- `pails`
- `paper-clip`
- `paper-plane`
- `parcel`
- `parcel-tracking`
- `password-check`
- `phone`
- `photoshop`
- `pill`
- `pointers`
- `printer`
- `pulse`
- `question`
- `question-2`
- `questionnaire-tablet`
- `ranking`
- `rescue`
- `row-horizontal`
- `row-vertical`
- `safe-home`
- `satellite`
- `save-2`
- `save-deposit`
- `scan-barcode`
- `scroll`
- `share`
- `shop`
- `social-media`
- `soft`
- `soft-2`
- `soft-3`
- `sort`
- `spring-framework`
- `star`
- `subtitle`
- `support`
- `tab-tablet`
- `tag`
- `tag-cross`
- `telephone-geolocation`
- `test-tubes`
- `text`
- `text-bold`
- `text-circle`
- `text-italic`
- `text-number`
- `text-strikethrough`
- `text-underline`
- `textalign-center`
- `textalign-justifycenter`
- `textalign-left`
- `textalign-right`
- `theta-theta`
- `underlining`
- `vibe-vibe`
- `watch`
- `wireframe`
- `xaomi`
- `xd`
- `xmr`
- `youtube`

## Cryptocurrency Icons
- `avalanche-avax`
- `binance`
- `binance-usd-busd`
- `bitcoin`
- `educare-ekt`
- `enjin-coin-enj`
- `nexo`
- `theta-theta`
- `vibe-vibe`
- `wanchain-wan`
- `xmr`

## Element Icons
- `element-1` through `element-12`
- `element-equal`
- `element-plus`

## Delivery & Logistics Icons
- `delivery`
- `delivery-2`
- `delivery-24`
- `delivery-3`
- `delivery-door`
- `delivery-geolocation`
- `delivery-time`
- `courier`
- `courier-express`
- `logistic`

## Design Icons
- `design-1`
- `design-2`
- `fatrows`
- `grid`
- `grid-2`

## Financial Icons
- `financial-schedule`
- `receipt-square`

## Health & Medical Icons
- `capsule`
- `syringe`
- `thermometer`

## Home & Living Icons
- `safe-home`
- `geolocation-home`
- `wifi-home`

## Industrial Icons
- `electricity`
- `electronic-clock`
- `external-drive`
- `pulse`

## Marketing Icons
- `discount`
- `price-tag`
- `ranking`

## Office Icons
- `office-bag`
- `briefcase`
- `printer`
- `pencil`

## Shopping Icons
- `basket`
- `basket-ok`
- `handcart`
- `lots-shopping`
- `shop`

## Sports & Entertainment Icons
- `joystick`
- `dj`
- `spotify`
- `youtube`

## Time & Schedule Icons
- `calendar`
- `calendar-2`
- `calendar-8`
- `calendar-add`
- `calendar-edit`
- `calendar-remove`
- `calendar-search`
- `calendar-tick`
- `time`
- `timer`

## Total Icons Available: 400+

All icons are available in four styles:
- **Duotone**: `.ki-icon-name.ki-duotone`
- **Filled**: `.ki-icon-name.ki-filled`
- **Outline**: `.ki-icon-name.ki-outline`
- **Solid**: `.ki-icon-name.ki-solid`

---

*This reference guide contains all available KeenIcons as of the current version. Icons can be used in templates with `{{ theme.getKeenIcon('icon-name') }}`.*
