import { toAbsoluteUrl } from '@/lib/helpers';
import { Company } from '../types/company';

export const CONNECTION_STRENGTHS = [
  {
    id: '1',
    name: 'Weak',
    color: 'bg-red-500 text-red-900 dark:bg-red-500 dark:text-red-100',
  },
  {
    id: '2',
    name: 'Medium',
    color:
      'bg-yellow-500 text-yellow-900 dark:bg-yellow-500 dark:text-yellow-100',
  },
  {
    id: '3',
    name: 'Strong',
    color: 'bg-green-500 text-green-900 dark:bg-green-500 dark:text-green-100',
  },
  {
    id: '4',
    name: 'Very Strong',
    color: 'bg-blue-500 text-blue-900 dark:bg-blue-500 dark:text-blue-100',
  },
  {
    id: '5',
    name: 'Extremely Strong',
    color:
      'bg-purple-500 text-purple-900 dark:bg-purple-500 dark:text-purple-100',
  },
];

export const COMPANIES: Company[] = [
  {
    id: '1',
    logo: toAbsoluteUrl('/media/brand-logos/tbg.svg'),
    name: 'TBG Corporation',
    domain: 'tbg.com',
    email: 'contact@tbg.com',
    phone: '+1-555-0101',
    description:
      'Leading provider of innovative solutions for insurange and corporate finannce',
    address: '123 Main St',
    city: 'San Francisco',
    state: 'CA',
    zip: '94101',
    country: 'USA',
    x: 'https://x.com/tbg',
    linkedin: 'https://linkedin.com/company/tbg',
    facebook: 'https://facebook.com/tbg',
    instagram: 'https://instagram.com/tbg',
    createdAt: new Date('2023-01-10T09:00:00Z'),
    updatedAt: new Date('2024-05-29T20:00:00Z'),
    foundedAt: new Date('2000-02-15T00:00:00Z'),
    categoryIds: ['1', '2', '3'],
    contactIds: ['1', '3'],
    estimatedArrId: '1',
    employeeRangeId: '1',
    connectionStrengthId: '5',
    lastInteractionAt: new Date('2024-05-28T19:00:00Z'),
    lastContacted: '12 days',
  },
  {
    id: '2',
    logo: '/media/brand-logos/discord.svg',
    name: 'Globex Inc',
    domain: 'globexinc.com',
    email: 'info@globexinc.com',
    phone: '+1-555-0102',
    description: 'Global exporter and distributor.',
    address: '456 Market St',
    city: 'New York',
    state: 'NY',
    zip: '10001',
    country: 'USA',
    x: 'https://x.com/globex',
    linkedin: 'https://linkedin.com/company/globex',
    facebook: 'https://facebook.com/globex',
    instagram: 'https://instagram.com/globex',
    createdAt: new Date('2022-03-05T10:00:00Z'),
    updatedAt: new Date('2024-05-28T19:00:00Z'),
    foundedAt: new Date('2010-06-10T00:00:00Z'),
    categoryIds: ['2', '3', '4'],
    contactIds: ['3', '4', '5'],
    estimatedArrId: '2',
    employeeRangeId: '2',
    connectionStrengthId: '2',
    lastInteractionAt: new Date('2024-05-22T16:30:00Z'),
    lastContacted: '2024-05-22T16:30:00Z',
  },
  {
    id: '3',
    logo: toAbsoluteUrl('/media/brand-logos/android.svg'),
    name: 'Initech',
    domain: 'initech.com',
    email: 'hello@initech.com',
    phone: '+1-555-0103',
    description: 'Tech solutions for modern businesses.',
    address: '789 Broadway',
    city: 'Austin',
    state: 'TX',
    zip: '73301',
    country: 'USA',
    x: 'https://x.com/initech',
    linkedin: 'https://linkedin.com/company/initech',
    facebook: 'https://facebook.com/initech',
    instagram: 'https://instagram.com/initech',
    createdAt: new Date('2021-07-12T11:00:00Z'),
    updatedAt: new Date('2024-05-27T18:00:00Z'),
    foundedAt: new Date('2015-09-20T00:00:00Z'),
    categoryIds: ['3', '4', '5'],
    contactIds: ['6', '7', '8'],
    estimatedArrId: '3',
    employeeRangeId: '3',
    connectionStrengthId: '3',
    lastInteractionAt: new Date('2024-05-22T11:00:00Z'),
    lastContacted: '2024-05-22T11:00:00Z',
  },
  {
    id: '4',
    logo: toAbsoluteUrl('/media/brand-logos/bithumb.svg'),
    name: 'Umbrella Corp',
    domain: 'umbrella.com',
    email: 'support@umbrella.com',
    phone: '+1-555-0104',
    description: 'Healthcare and pharmaceutical leader.',
    address: '101 State St',
    city: 'Chicago',
    state: 'IL',
    zip: '60601',
    country: 'USA',
    x: 'https://x.com/umbrella',
    linkedin: 'https://linkedin.com/company/umbrella',
    facebook: 'https://facebook.com/umbrella',
    instagram: 'https://instagram.com/umbrella',
    createdAt: new Date('2020-05-20T12:00:00Z'),
    updatedAt: new Date('2024-05-26T17:00:00Z'),
    foundedAt: new Date('1998-11-30T00:00:00Z'),
    categoryIds: ['4', '5', '1'],
    contactIds: ['9', '10', '11'],
    estimatedArrId: '4',
    employeeRangeId: '4',
    connectionStrengthId: '4',
    lastInteractionAt: new Date('2024-05-23T10:00:00Z'),
    lastContacted: '4 days',
  },
  {
    id: '5',
    logo: toAbsoluteUrl('/media/brand-logos/btcexchange.svg'),
    name: 'Hooli',
    domain: 'hooli.com',
    email: 'info@hooli.com',
    phone: '+1-555-0105',
    description: 'Innovative tech for everyone.',
    address: '202 Silicon Ave',
    city: 'Palo Alto',
    state: 'CA',
    zip: '94301',
    country: 'USA',
    x: 'https://x.com/hooli',
    linkedin: 'https://linkedin.com/company/hooli',
    facebook: 'https://facebook.com/hooli',
    instagram: 'https://instagram.com/hooli',
    createdAt: new Date('2023-09-15T13:00:00Z'),
    updatedAt: new Date('2024-05-25T16:00:00Z'),
    foundedAt: new Date('2012-04-01T00:00:00Z'),
    categoryIds: ['5', '6'],
    contactIds: ['12', '13', '14'],
    estimatedArrId: '5',
    employeeRangeId: '5',
    connectionStrengthId: '5',
    lastInteractionAt: new Date('2024-05-24T09:00:00Z'),
    lastContacted: 'about 6 hours',
  },
  {
    id: '6',
    logo: toAbsoluteUrl('/media/brand-logos/btcchina.svg'),
    name: 'Stark Industries',
    domain: 'starkindustries.com',
    email: 'contact@starkindustries.com',
    phone: '+1-555-0106',
    description: 'Advanced weaponry and technology.',
    address: '10880 Malibu Point',
    city: 'Malibu',
    state: 'CA',
    zip: '90265',
    country: 'USA',
    x: 'https://x.com/starkindustries',
    linkedin: 'https://linkedin.com/company/starkindustries',
    facebook: 'https://facebook.com/starkindustries',
    instagram: 'https://instagram.com/starkindustries',
    createdAt: new Date('2023-02-10T09:00:00Z'),
    updatedAt: new Date('2024-05-24T20:00:00Z'),
    foundedAt: new Date('1990-05-01T00:00:00Z'),
    categoryIds: ['6', '7', '8'],
    contactIds: ['15', '17'],
    estimatedArrId: '6',
    employeeRangeId: '6',
    connectionStrengthId: '1',
    lastInteractionAt: new Date('2024-05-19T15:00:00Z'),
    lastContacted: '7 days',
  },
  {
    id: '7',
    logo: toAbsoluteUrl('/media/brand-logos/bridgefy.svg'),
    name: 'Wayne Enterprises',
    domain: 'wayneenterprises.com',
    email: 'info@wayneenterprises.com',
    phone: '+1-555-0107',
    description: 'Conglomerate with interests in tech and real estate.',
    address: '1007 Mountain Dr',
    city: 'Gotham',
    state: 'NJ',
    zip: '07001',
    country: 'USA',
    x: 'https://x.com/wayneenterprises',
    linkedin: 'https://linkedin.com/company/wayneenterprises',
    facebook: 'https://facebook.com/wayneenterprises',
    instagram: 'https://instagram.com/wayneenterprises',
    createdAt: new Date('2022-04-11T10:00:00Z'),
    updatedAt: new Date('2024-05-23T19:00:00Z'),
    foundedAt: new Date('1980-03-10T00:00:00Z'),
    categoryIds: ['7', '8', '9'],
    contactIds: ['5', '7'],
    estimatedArrId: '1',
    employeeRangeId: '7',
    connectionStrengthId: '2',
    lastInteractionAt: new Date('2024-05-18T13:00:00Z'),
    lastContacted: 'about 2 hours ago',
  },
  {
    id: '8',
    logo: toAbsoluteUrl('/media/brand-logos/coinhodler.svg'),
    name: 'Oscorp',
    domain: 'oscorp.com',
    email: 'hello@oscorp.com',
    phone: '+1-555-0108',
    description: 'Biotechnology and chemical research.',
    address: '200 Park Ave',
    city: 'New York',
    state: 'NY',
    zip: '10166',
    country: 'USA',
    x: 'https://x.com/oscorp',
    linkedin: 'https://linkedin.com/company/oscorp',
    facebook: 'https://facebook.com/oscorp',
    instagram: 'https://instagram.com/oscorp',
    createdAt: new Date('2021-08-12T11:00:00Z'),
    updatedAt: new Date('2024-05-22T18:00:00Z'),
    foundedAt: new Date('2005-07-20T00:00:00Z'),
    categoryIds: ['8', '9', '10'],
    contactIds: ['1', '5', '11'],
    estimatedArrId: '2',
    employeeRangeId: '8',
    connectionStrengthId: '3',
    lastInteractionAt: new Date('2024-05-17T11:00:00Z'),
    lastContacted: '2 days',
  },
  {
    id: '9',
    logo: toAbsoluteUrl('/media/brand-logos/divi.svg'),
    name: 'LexCorp',
    domain: 'lexcorp.com',
    email: 'contact@lexcorp.com',
    phone: '+1-555-0109',
    description: 'Industrial and technology powerhouse.',
    address: '300 Industrial Rd',
    city: 'Metropolis',
    state: 'IL',
    zip: '62960',
    country: 'USA',
    x: 'https://x.com/lexcorp',
    linkedin: 'https://linkedin.com/company/lexcorp',
    facebook: 'https://facebook.com/lexcorp',
    instagram: 'https://instagram.com/lexcorp',
    createdAt: new Date('2020-06-20T12:00:00Z'),
    updatedAt: new Date('2024-05-21T17:00:00Z'),
    foundedAt: new Date('1995-09-30T00:00:00Z'),
    categoryIds: ['1', '3', '5'],
    contactIds: ['18'],
    estimatedArrId: '3',
    employeeRangeId: '9',
    connectionStrengthId: '4',
    lastInteractionAt: new Date('2024-05-16T10:00:00Z'),
    lastContacted: 'about 4 hours',
  },
  {
    id: '10',
    logo: toAbsoluteUrl('/media/brand-logos/discord.svg'),
    name: 'Daily Planet',
    domain: 'dailyplanet.com',
    email: 'editor@dailyplanet.com',
    phone: '+1-555-0110',
    description: 'Leading news and media company.',
    address: '400 News Blvd',
    city: 'Metropolis',
    state: 'IL',
    zip: '62960',
    country: 'USA',
    x: 'https://x.com/dailyplanet',
    linkedin: 'https://linkedin.com/company/dailyplanet',
    facebook: 'https://facebook.com/dailyplanet',
    instagram: 'https://instagram.com/dailyplanet',
    createdAt: new Date('2023-03-15T13:00:00Z'),
    updatedAt: new Date('2024-05-20T16:00:00Z'),
    foundedAt: new Date('1970-01-01T00:00:00Z'),
    categoryIds: ['2', '4', '6'],
    contactIds: ['6', '19'],
    estimatedArrId: 'arr5',
    employeeRangeId: 'emp2',
    connectionStrengthId: '5',
    lastInteractionAt: new Date('2024-05-15T09:00:00Z'),
    lastContacted: '3 months',
  },
  {
    id: '11',
    logo: toAbsoluteUrl('/media/brand-logos/django.svg'),
    name: 'Pied Piper',
    domain: 'piedpiper.com',
    email: 'info@piedpiper.com',
    phone: '+1-555-0111',
    description: 'Revolutionizing data compression.',
    address: '500 Startup Lane',
    city: 'Palo Alto',
    state: 'CA',
    zip: '94301',
    country: 'USA',
    x: 'https://x.com/piedpiper',
    linkedin: 'https://linkedin.com/company/piedpiper',
    facebook: 'https://facebook.com/piedpiper',
    instagram: 'https://instagram.com/piedpiper',
    createdAt: new Date('2022-10-10T14:00:00Z'),
    updatedAt: new Date('2024-05-19T15:00:00Z'),
    foundedAt: new Date('2018-04-01T00:00:00Z'),
    categoryIds: ['4', '6', '3'],
    contactIds: ['7', '19'],
    estimatedArrId: '4',
    employeeRangeId: '4',
    connectionStrengthId: '1',
    lastInteractionAt: new Date('2024-05-14T08:00:00Z'),
    lastContacted: '7 months',
  },
  {
    id: '12',
    logo: toAbsoluteUrl('/media/brand-logos/foursquare.svg'),
    name: 'Monarch Solutions',
    domain: 'monarchsolutions.com',
    email: 'contact@monarchsolutions.com',
    phone: '+1-555-0112',
    description: 'Innovative time technology.',
    address: '600 Quantum Rd',
    city: 'Seattle',
    state: 'WA',
    zip: '98101',
    country: 'USA',
    x: 'https://x.com/monarchsolutions',
    linkedin: 'https://linkedin.com/company/monarchsolutions',
    facebook: 'https://facebook.com/monarchsolutions',
    instagram: 'https://instagram.com/monarchsolutions',
    createdAt: new Date('2021-05-20T12:00:00Z'),
    updatedAt: new Date('2024-05-18T14:00:00Z'),
    foundedAt: new Date('2014-08-15T00:00:00Z'),
    categoryIds: ['2', '1', '4'],
    contactIds: ['2', '9'],
    estimatedArrId: '6',
    employeeRangeId: '1',
    connectionStrengthId: '2',
    lastInteractionAt: new Date('2024-05-13T07:00:00Z'),
    lastContacted: '1 month',
  },
  {
    id: '13',
    logo: toAbsoluteUrl('/media/brand-logos/general-electric.svg'),
    name: 'Massive Dynamic',
    domain: 'massivedynamic.com',
    email: 'hello@massivedynamic.com',
    phone: '+1-555-0113',
    description: 'Cutting-edge science and tech.',
    address: '700 Future Ave',
    city: 'Boston',
    state: 'MA',
    zip: '02101',
    country: 'USA',
    x: 'https://x.com/massivedynamic',
    linkedin: 'https://linkedin.com/company/massivedynamic',
    facebook: 'https://facebook.com/massivedynamic',
    instagram: 'https://instagram.com/massivedynamic',
    createdAt: new Date('2020-11-01T08:00:00Z'),
    updatedAt: new Date('2024-05-17T13:00:00Z'),
    foundedAt: new Date('2007-06-10T00:00:00Z'),
    categoryIds: ['5', '9', '10'],
    contactIds: ['3', '1', '5'],
    estimatedArrId: '3',
    employeeRangeId: '5',
    connectionStrengthId: '3',
    lastInteractionAt: new Date('2024-05-12T06:00:00Z'),
    lastContacted: '9 days',
  },
  {
    id: '14',
    logo: toAbsoluteUrl('/media/brand-logos/gitlab.svg'),
    name: 'Cyberdyne Systems',
    domain: 'cyberdyne.com',
    email: 'support@cyberdyne.com',
    phone: '+1-555-0114',
    description: 'Robotics and artificial intelligence.',
    address: '800 AI Blvd',
    city: 'San Jose',
    state: 'CA',
    zip: '95112',
    country: 'USA',
    x: 'https://x.com/cyberdyne',
    linkedin: 'https://linkedin.com/company/cyberdyne',
    facebook: 'https://facebook.com/cyberdyne',
    instagram: 'https://instagram.com/cyberdyne',
    createdAt: new Date('2023-06-15T09:00:00Z'),
    updatedAt: new Date('2024-05-16T12:00:00Z'),
    foundedAt: new Date('2010-09-20T00:00:00Z'),
    categoryIds: ['1', '2', '3'],
    contactIds: ['2', '6', '4'],
    estimatedArrId: '2',
    employeeRangeId: '3',
    connectionStrengthId: '4',
    lastInteractionAt: new Date('2024-05-11T05:00:00Z'),
    lastContacted: '12 days',
  },
  {
    id: '15',
    logo: toAbsoluteUrl('/media/brand-logos/kickstarter.svg'),
    name: 'Vandelay Industries',
    domain: 'vandelay.com',
    email: 'info@vandelay.com',
    phone: '+1-555-0115',
    description: 'Importer-exporter of fine latex goods.',
    address: '900 Latex Rd',
    city: 'Miami',
    state: 'FL',
    zip: '33101',
    country: 'USA',
    x: 'https://x.com/vandelay',
    linkedin: 'https://linkedin.com/company/vandelay',
    facebook: 'https://facebook.com/vandelay',
    instagram: 'https://instagram.com/vandelay',
    createdAt: new Date('2022-07-15T10:00:00Z'),
    updatedAt: new Date('2024-05-15T11:00:00Z'),
    foundedAt: new Date('2001-03-15T00:00:00Z'),
    categoryIds: ['5', '6', '7'],
    contactIds: ['3', '1', '5'],
    estimatedArrId: '1',
    employeeRangeId: '7',
    connectionStrengthId: '5',
    lastInteractionAt: new Date('2024-05-10T04:00:00Z'),
    lastContacted: '3 months',
  },
  {
    id: '16',
    logo: 'https://logo.clearbit.com/soylent.com',
    name: 'Soylent Corp',
    domain: 'soylent.com',
    email: 'contact@soylent.com',
    phone: '+1-555-0116',
    description: 'Nutritional food products.',
    address: '1000 Green Rd',
    city: 'Los Angeles',
    state: 'CA',
    zip: '90001',
    country: 'USA',
    x: 'https://x.com/soylent',
    linkedin: 'https://linkedin.com/company/soylent',
    facebook: 'https://facebook.com/soylent',
    instagram: 'https://instagram.com/soylent',
    createdAt: new Date('2021-12-10T15:00:00Z'),
    updatedAt: new Date('2024-05-14T10:00:00Z'),
    foundedAt: new Date('2013-05-10T00:00:00Z'),
    categoryIds: ['9', '10', '3'],
    contactIds: ['9', '7'],
    estimatedArrId: '6',
    employeeRangeId: '1',
    connectionStrengthId: '1',
    lastInteractionAt: new Date('2024-05-09T03:00:00Z'),
    lastContacted: '12 hours',
  },
  {
    id: '17',
    logo: toAbsoluteUrl('/media/brand-logos/monday.svg'),
    name: 'Tyrell Corporation',
    domain: 'tyrell.com',
    email: 'hello@tyrell.com',
    phone: '+1-555-0117',
    description: 'Genetic engineering and replicants.',
    address: '1100 Blade Runner St',
    city: 'Los Angeles',
    state: 'CA',
    zip: '90012',
    country: 'USA',
    x: 'https://x.com/tyrell',
    linkedin: 'https://linkedin.com/company/tyrell',
    facebook: 'https://facebook.com/tyrell',
    instagram: 'https://instagram.com/tyrell',
    createdAt: new Date('2023-08-10T16:00:00Z'),
    updatedAt: new Date('2024-05-13T09:00:00Z'),
    foundedAt: new Date('2009-02-20T00:00:00Z'),
    categoryIds: ['2', '4', '6'],
    contactIds: ['7', '4', '11'],
    estimatedArrId: '4',
    employeeRangeId: '6',
    connectionStrengthId: '2',
    lastInteractionAt: new Date('2024-05-08T02:00:00Z'),
    lastContacted: '17 days',
  },
  {
    id: '18',
    logo: toAbsoluteUrl('/media/brand-logos/myriadcoin.svg'),
    name: 'Wonka Industries',
    domain: 'wonka.com',
    email: 'info@wonka.com',
    phone: '+1-555-0118',
    description: 'Candy and chocolate manufacturing.',
    address: '1200 Chocolate Ave',
    city: 'Hershey',
    state: 'PA',
    zip: '17033',
    country: 'USA',
    x: 'https://x.com/wonka',
    linkedin: 'https://linkedin.com/company/wonka',
    facebook: 'https://facebook.com/wonka',
    instagram: 'https://instagram.com/wonka',
    createdAt: new Date('2022-09-10T17:00:00Z'),
    updatedAt: new Date('2024-05-12T08:00:00Z'),
    foundedAt: new Date('1964-07-01T00:00:00Z'),
    categoryIds: ['1', '2', '3'],
    contactIds: ['3', '1', '5'],
    estimatedArrId: '5',
    employeeRangeId: '8',
    connectionStrengthId: '1',
    lastInteractionAt: new Date('2024-05-07T01:00:00Z'),
    lastContacted: '23 days',
  },
  {
    id: '19',
    logo: toAbsoluteUrl('/media/brand-logos/monetha.svg'),
    name: 'Bluth Company',
    domain: 'bluthcompany.com',
    email: 'contact@bluthcompany.com',
    phone: '+1-555-0119',
    description: 'Real estate development.',
    address: '1300 Banana Stand',
    city: 'Newport Beach',
    state: 'CA',
    zip: '92660',
    country: 'USA',
    x: 'https://x.com/bluthcompany',
    linkedin: 'https://linkedin.com/company/bluthcompany',
    facebook: 'https://facebook.com/bluthcompany',
    instagram: 'https://instagram.com/bluthcompany',
    createdAt: new Date('2021-03-10T18:00:00Z'),
    updatedAt: new Date('2024-05-11T07:00:00Z'),
    foundedAt: new Date('1979-06-15T00:00:00Z'),
    categoryIds: ['6', '7', '9'],
    contactIds: ['3', '1'],
    estimatedArrId: '1',
    employeeRangeId: '9',
    connectionStrengthId: '1',
    lastInteractionAt: new Date('2024-05-06T00:00:00Z'),
    lastContacted: '11 months',
  },
  {
    id: '20',
    logo: toAbsoluteUrl('/media/brand-logos/shell.svg'),
    name: 'Prestige Worldwide',
    domain: 'prestigeworldwide.com',
    email: 'info@prestigeworldwide.com',
    phone: '+1-555-0120',
    description: 'Entertainment and management.',
    address: '1400 Catalina Dr',
    city: 'Santa Barbara',
    state: 'CA',
    zip: '93101',
    country: 'USA',
    x: 'https://x.com/prestigeworldwide',
    linkedin: 'https://linkedin.com/company/prestigeworldwide',
    facebook: 'https://facebook.com/prestigeworldwide',
    instagram: 'https://instagram.com/prestigeworldwide',
    createdAt: new Date('2023-11-10T19:00:00Z'),
    updatedAt: new Date('2024-05-10T06:00:00Z'),
    foundedAt: new Date('2008-11-11T00:00:00Z'),
    categoryIds: ['1', '2', '3'],
    contactIds: ['11', '9', '4'],
    estimatedArrId: '2',
    employeeRangeId: '2',
    connectionStrengthId: '3',
    lastInteractionAt: new Date('2024-05-05T23:00:00Z'),
    lastContacted: '9 hours',
  },
];
