import { useEffect, useRef, useState } from 'react';
import { AccountSettingsSidebar } from '@/pages/account/home/settings-sidebar';
import {
  AdvancedSettingsAddress,
  AdvancedSettingsAppearance,
  AdvancedSettingsNotifications,
  AdvancedSettingsPreferences,
  AuthEmail,
  AuthPassword,
  AuthSingleSingOn,
  AuthSocialSignIn,
  AuthTwoFactor,
  BasicSettings,
  DeleteAccount,
  ExternalServicesIntegrations,
  ExternalServicesManageApi,
} from '@/pages/account/home/settings-sidebar/components';
import { useIsMobile } from '@/hooks/use-mobile';
import { useViewport } from '@/hooks/use-viewport';
import { Button } from '@/components/ui/button';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
} from '@/components/ui/dialog';
import { ScrollArea } from '@/components/ui/scroll-area';
import { Scrollspy } from '@/components/ui/scrollspy';

export function AccountSettingsModal({ open, onOpenChange }) {
  const mobileMode = useIsMobile();
  const navBar = useRef(null);
  const parentRef = useRef(null);
  const [sidebarHeight, setSidebarHeight] = useState(0);
  const [viewportHeight] = useViewport();
  const offset = 260;

  useEffect(() => {
    setSidebarHeight(viewportHeight - offset);
  }, [viewportHeight]);

  return (
    <Dialog open={open} onOpenChange={onOpenChange}>
      <DialogContent
        className="mx-auto grow w-full max-w-[1320px] flex flex-col px-10 gap-0 overflow-hidden [&>button]:hidden"
        variant="fullscreen"
      >
        <DialogHeader className="p-0 border-0">
          <DialogTitle></DialogTitle>
          <DialogDescription></DialogDescription>
          <div className="flex items-center justify-between flex-wrap grow gap-5 pb-7.5">
            <div className="flex flex-col justify-center gap-2">
              <h1 className="text-xl font-semibold leading-none text-mono">
                Settings - Modal
              </h1>
              <div className="flex items-center gap-2 text-sm font-normal text-secondary-foreground">
                Dynamic, Focused Adjustment Interface
              </div>
            </div>
            <Button onClick={onOpenChange} variant="outline">
              Close
            </Button>
          </div>
        </DialogHeader>
        <ScrollArea
          className="grow py-0 mb-5 ps-0 pe-3 -me-7"
          viewportRef={parentRef}
        >
          <div className="flex grow gap-5 lg:gap-7.5">
            {!mobileMode && (
              <div
                className="w-[300px] sticky top-[1px]"
                style={{ maxHeight: `${sidebarHeight}px` }}
              >
                <ScrollArea viewportRef={navBar} className="h-full">
                  <Scrollspy offset={100} targetRef={parentRef}>
                    <AccountSettingsSidebar />
                  </Scrollspy>
                </ScrollArea>
              </div>
            )}
            <div className="flex flex-col items-stretch grow gap-5 lg:gap-7.5">
              <BasicSettings />
              <AuthEmail />
              <AuthPassword />
              <AuthSocialSignIn />
              <AuthSingleSingOn />
              <AuthTwoFactor />
              <AdvancedSettingsPreferences />
              <AdvancedSettingsAppearance title={''} />
              <AdvancedSettingsNotifications />
              <AdvancedSettingsAddress />
              <ExternalServicesManageApi title={''} switch={false} />
              <ExternalServicesIntegrations />
              <DeleteAccount />
            </div>
          </div>
        </ScrollArea>
      </DialogContent>
    </Dialog>
  );
}
