import {
  Breadcrumb,
  BreadcrumbList,
  BreadcrumbItem,
  BreadcrumbSeparator,
  BreadcrumbLink,
  BreadcrumbPage
} from "@/components/ui/breadcrumb";

export function ToolbarBreadcrumbs() {  
  return (
    <div className="flex flex-row items-center flex-wrap gap-1">
      <Breadcrumb>
        <BreadcrumbList> 
          <BreadcrumbItem>
            <BreadcrumbLink href="/">Home</BreadcrumbLink>
          </BreadcrumbItem>
          <BreadcrumbSeparator className="text-xs text-muted-foreground">/</BreadcrumbSeparator>
          <BreadcrumbItem>
            <BreadcrumbLink href="/">My Account</BreadcrumbLink>
          </BreadcrumbItem>
          <BreadcrumbSeparator className="text-xs text-muted-foreground">/</BreadcrumbSeparator>
          <BreadcrumbItem>
            <BreadcrumbPage>Team Settings</BreadcrumbPage>
          </BreadcrumbItem>
        </BreadcrumbList>
      </Breadcrumb>
    </div>
  );
}
